/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.contact;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.juddi.datatype.Phone;
import org.apache.juddi.datatype.business.Contact;

public class VWContactPhoneTableModel
extends AbstractTableModel {
    protected static final int COLUMN_ID = 0;
    protected static final int COLUMN_PHONE = 1;
    protected static final int COLUMN_TYPE = 2;
    protected String[] m_columnNames = new String[]{"", VWResource.s_phone, VWResource.s_type};
    protected Frame m_parentFrame = null;
    private Vector m_rowData = null;
    private boolean m_bHasChanged = false;
    private Contact m_contact = null;

    public VWContactPhoneTableModel(Frame parent, Contact theContact) {
        try {
            Vector sourcePhoneVector;
            this.m_parentFrame = parent;
            this.m_contact = theContact;
            this.m_rowData = new Vector();
            if (this.m_contact != null && (sourcePhoneVector = this.m_contact.getPhoneVector()) != null) {
                int sz = sourcePhoneVector.size();
                for (int i = 0; i < sz; ++i) {
                    Phone sourcePhone = (Phone)sourcePhoneVector.elementAt(i);
                    if (sourcePhone == null) continue;
                    Phone newPhone = new Phone();
                    newPhone.setValue(sourcePhone.getValue());
                    newPhone.setUseType(sourcePhone.getUseType());
                    this.m_rowData.addElement(newPhone);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void resetData(Vector data) {
        this.m_rowData.clear();
        this.m_rowData = data;
    }

    public void setPhoneVector(Vector data) {
        this.m_rowData = data;
    }

    public Phone getPhone(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.m_rowData.size()) {
            return null;
        }
        return (Phone)this.m_rowData.elementAt(rowIndex);
    }

    public void setPhone(Phone thePhone, int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.m_rowData.size() || thePhone == null) {
            return;
        }
        this.m_rowData.setElementAt(thePhone, rowIndex);
        this.m_bHasChanged = true;
    }

    public void addRow() {
        try {
            if (this.m_rowData == null) {
                this.m_rowData = new Vector();
            }
            this.m_rowData.addElement(new Phone());
            int nRow = this.m_rowData.size() - 1;
            this.fireTableRowsInserted(nRow, nRow);
            this.m_bHasChanged = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public String getColumnName(int nColumn) {
        if (nColumn < 0 || nColumn > this.m_columnNames.length) {
            return null;
        }
        return this.m_columnNames[nColumn];
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return null;
            }
            Phone ophone = (Phone)this.m_rowData.elementAt(nRowIndex);
            if (ophone == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return String.valueOf(nRowIndex + 1);
                }
                case 1: {
                    String phone = ophone.getValue();
                    if (phone == null) {
                        phone = "";
                    }
                    return phone;
                }
                case 2: {
                    String type = ophone.getUseType();
                    if (type == null) {
                        type = "";
                    }
                    return type;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        return nColumn != 0;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return;
            }
            Phone oPhone = (Phone)this.m_rowData.elementAt(nRowIndex);
            if (oPhone == null) {
                return;
            }
            switch (nColumnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    oPhone.setValue((String)aValue);
                    this.m_bHasChanged = true;
                    break;
                }
                case 2: {
                    oPhone.setUseType((String)aValue);
                    this.m_bHasChanged = true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean verifyPhones() {
        boolean bSuccess = true;
        if (this.m_rowData != null) {
            int sz = this.m_rowData.size();
            for (int i = 0; i < sz; ++i) {
                Phone phoneItem = (Phone)this.m_rowData.elementAt(i);
                String phoneStr = phoneItem.getValue();
                if (phoneStr != null && phoneStr.length() >= 1) continue;
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_missingContactPhone.toString(String.valueOf(i + 1)), VWResource.s_errorMessage, 1);
                bSuccess = false;
            }
        }
        return bSuccess;
    }

    public Vector getPhoneVector() {
        return this.m_rowData;
    }

    public void releaseResources() {
    }

    public void up(int rowIndex) {
        try {
            if (rowIndex != 0) {
                Object currentObj = this.m_rowData.elementAt(rowIndex);
                Object previousObj = this.m_rowData.elementAt(rowIndex - 1);
                this.m_rowData.setElementAt(currentObj, rowIndex - 1);
                this.m_rowData.setElementAt(previousObj, rowIndex);
                this.m_bHasChanged = true;
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void down(int rowIndex) {
        try {
            if (rowIndex < this.getRowCount() - 1) {
                Object currentObj = this.m_rowData.elementAt(rowIndex);
                Object previousObj = this.m_rowData.elementAt(rowIndex + 1);
                this.m_rowData.setElementAt(currentObj, rowIndex + 1);
                this.m_rowData.setElementAt(previousObj, rowIndex);
                this.m_bHasChanged = true;
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeRow(int nRow) {
        try {
            if (this.m_rowData == null || nRow < 0 || nRow >= this.m_rowData.size()) {
                return;
            }
            Phone rowItem = (Phone)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                this.m_rowData.removeElementAt(nRow);
                this.fireTableRowsDeleted(nRow, nRow);
                this.m_bHasChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void delete(int rowIndex) {
        try {
            if (rowIndex >= 0 && rowIndex < this.m_rowData.size()) {
                this.m_rowData.removeElementAt(rowIndex);
                this.fireTableRowsDeleted(rowIndex, rowIndex);
                this.m_bHasChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String checkDuplicateName(String uddiName, int row) {
        String msg = null;
        if (uddiName == null || uddiName.trim().length() < 1) {
            msg = VWResource.s_missingUDDIRegName.toString(String.valueOf(row + 1));
            return msg;
        }
        int rowCount = this.m_rowData.size();
        for (int i = 0; i < rowCount; ++i) {
            if (i == row) continue;
            VWUDDIRegistry uddiReg = (VWUDDIRegistry)this.m_rowData.elementAt(i);
            String urName = uddiReg.getName();
            if (urName == null || urName.length() < 1) {
                msg = VWResource.s_missingUDDIRegName.toString(String.valueOf(i + 1));
                break;
            }
            if (uddiName.compareTo(urName) != 0) continue;
            msg = VWResource.s_duplicatedPhoneNumber.toString(uddiName, String.valueOf(i + 1), String.valueOf(row + 1));
            break;
        }
        return msg;
    }
}

